#include <bits/stdc++.h>
using namespace std;
#define ll long long
const int N = 2e5 + 10;
const int L = 25;
struct DSU {
    int pr[N], sz[N];
    void init(int n) { for (int i = 1; i <= n; i++) { pr[i] = i; } }
    int root(int x) { return pr[x] == x ? x : pr[x] = root(pr[x]); }
    void unite(int x, int y) { pr[root(y)] = root(x); }
    bool same(int x, int y) { return root(x) == root(y); }
} D;
vector<pair<int, int>> g[N];
int up[N][L], dep[N], mx[N][L];
void add_edge(int x, int y, int w) {
    g[x].emplace_back(y, w);
    g[y].emplace_back(x, w);
}
void dfs(int x, int fa) {
    up[x][0] = fa;
    for (int j = 1; j < L; j++) {
        up[x][j] = up[up[x][j - 1]][j - 1];
    }
    dep[x] = dep[fa] + 1;
    for (auto& p : g[x]) {
        int y = p.first;
        int w = p.second;
        if (y == fa) continue;
        mx[y][0] = w;
        dfs(y, x);
    }
}
int lca(int x, int y) {
    if (dep[x] > dep[y]) {
        swap(x, y);
    }
    for (int j = L - 1; j >= 0; j--) {
        if (dep[up[y][j]] >= dep[x]) {
            y = up[y][j];
        }
    }
    if (x == y) {
        return x;
    }
    for (int j = L - 1; j >= 0; j--) {
        if (up[x][j] != up[y][j]) {
            x = up[x][j];
            y = up[y][j];
        }
    }
    return up[x][0];
}
bool is[N];
ll Resi(int n, int m, int k, int *u, int *v) {
    D.init(n);
    for (int i = 1; i <= m; i++) {
        if (D.same(u[i], v[i])) { is[i] = false; continue; }
        add_edge(u[i], v[i], (i + k - 1) / k);
        is[i] = true;
        D.unite(u[i], v[i]);
    }
    mx[1][0] = -1e9;
    dfs(1, 1);
//    for (int j = 1; j < L; j++) {
//        for (int i = 1; i <= n; i++) {
//            mx[i][j] = max(mx[i][j - 1], mx[]);
//        }
//    }
    if (m == k) {
        ll ans = 0;
        for (int i = 1; i <= n; i++) {
            for (int j = i + 1; j <= n; j++) {
                vector<bool> is_x(n + 1);
                vector<bool> is_y(n + 1);
                for (int x = 1; x <= m; x++) {
                    if (u[x] == i || v[x] == i) {
                        is_x[(u[x] ^ v[x] ^ i)] = true;
                    }
                    if (u[x] == j || v[x] == j) {
                        is_y[(u[x] ^ v[x] ^ j)] = true;
                    }
                }
                int xs = 0, ys = 0, bth = 0;
                for (int x = 1; x <= n; x++) {
                    if (i == x || j == x) continue;
                    if (is_x[x] && is_y[x]) {
                        bth += 1;
                        xs += 1;
                        ys += 1;
                        continue;
                    }
                    xs += is_x[x];
                    ys += is_y[x];
                }
                int res = xs + ys - bth + (bth != 0 || is_x[j] ? 1 : 0);
//                res = min();
                ans += res;
            }
        }
        return ans;
    }
}
/*
4 4 4
1 2
2 3
3 4
4 1
*/