#include <bits/stdc++.h>
using namespace std;

using ll = long long;

class DSU {
private:
    int n;
    vector<int> rod;
    vector<int> vel;
public:
    DSU(int _n) : n(_n) {
        rod.resize(n + 1);
        iota(rod.begin(), rod.end(), 0);
        vel.assign(n + 1, 1);
    }

    int findSet(int u) {
        if(rod[u] == u) return u;
        return rod[u] = findSet(rod[u]);
    }

    bool unite(int u, int v) {
        u = findSet(u);
        v = findSet(v);

        if(u == v) return false;

        if(vel[u] > vel[v]) swap(u, v);

        vel[v] += vel[u];
        rod[u] = v;

        return true;
    }
};

long long Resi(int N, int M, int K, int *U, int *V){
    ll ans = 0;
    for(int i = 1; i <= N; ++i) {
        for(int j = i + 1; j <= N; ++j) {
            int u = U[i];
            int v = U[j];

            vector<pair<int, pair<int, int>>> edges;
            edges.reserve(M);

            for(int k = 0; k < M; ++k) {
                edges.push_back({(k + 1 + K - 1) / K, {U[k + 1], V[k + 1]}});
            }

            sort(edges.begin(), edges.end(), [&](pair<int, pair<int, int>> a, pair<int, pair<int, int>> b) {
                 if(a.first != b.first) return a.first < b.first;

                 int cnt1 = 0;
                 cnt1 += (a.second.first == u || a.second.second == u);
                 cnt1 += (a.second.first == v || a.second.second == v);

                 int cnt2 = 0;
                 cnt2 += (b.second.first == u || b.second.second == u);
                 cnt2 += (b.second.first == v || b.second.second == v);

                 return cnt1 > cnt2;
            });

//            if(u == 1 && v == 2) {
//                cout << "Ivice" << endl;
//                for(auto z : edges) {
//                    cout << z.second.first << " " << z.second.second << endl;
//                }
//            }

            DSU d(N);
            vector<int> deg(N + 1);

            for(auto z : edges) {
                if(d.unite(z.second.first, z.second.second)) {
                    ++deg[z.second.first];
                    ++deg[z.second.second];
                }
            }

            ans += deg[u] + deg[v];
        }
    }

    return ans;
}