#include <iostream>
#include <vector>
#include <queue>

using namespace std;

// vector<vector<int>> generateNewPlan(const vector<vector<int>>& oldPlan) {
//     int size = oldPlan.size();
//     vector<vector<int>> newPlan(size, vector<int>(size, 0));

//     for (int i = 0; i < size; i++)
//         for (int j = 0; j < size; j++)
//             if (i != j && oldPlan[i][j] == 1)
//                 for (int k = 0; k < size; k++)
//                     if (j != k && oldPlan[j][k] == 1)
//                         newPlan[i][k] = 1;

//     return newPlan;
// }

int calculateShortestRoute(const vector<vector<int>>& plan, int startingPoint, int finalDestination) {
    int size = plan.size();
    vector<bool> visited(size, false);
    queue<pair<int, int>> q;
    q.push({startingPoint, 0});
    visited[startingPoint] = true;

    while (!q.empty()) {
        int node = q.front().first;
        int steps = q.front().second;
        q.pop();

        if (node == finalDestination) {
            return steps;
        }

        for (int i = 0; i < size; i++) {
            if (plan[node][i] == 1 && !visited[i]) {
                q.push({i, steps + 1});
                visited[i] = true;
            }
        }
    }

    return -1;
}

int main() {
    int n, m, s, t;
    cin >> n >> m >> s >> t;

    vector<vector<int>> oldPlan(n, vector<int>(n, 0));

    for (int i = 0; i < m; i++) {
        int a, b;
        cin >> a >> b;
        oldPlan[a - 1][b - 1] = 1;
        oldPlan[b - 1][a - 1] = 1;
    }

    // vector<vector<int>> newPlan = generateNewPlan(oldPlan);

    // cout << calculateShortestRoute(newPlan, s - 1, t - 1);
    cout << calculateShortestRoute(oldPlan, s - 1, t - 1);
    
    return 0;
}