#include <stdio.h>
#include <stdlib.h>

#define MAX_STATIONS 1000

typedef struct {
    int station;
    struct Node* next;
} Node;

typedef struct {
    Node* head;
} List;

List graph[MAX_STATIONS + 1];
int posecene[MAX_STATIONS + 1];

void initializeGraph(int n) {
    for (int i = 1; i <= n; i++) {
        graph[i].head = NULL;
        posecene[i] = 0;
    }
}

void addEdge(int u, int v) {
    Node* newNode = (Node*)malloc(sizeof(Node));
    newNode->station = v;
    newNode->next = graph[u].head;
    graph[u].head = newNode;

    newNode = (Node*)malloc(sizeof(Node));
    newNode->station = u;
    newNode->next = graph[v].head;
    graph[v].head = newNode;
}

int bfs(int pocetak, int kraj, int n) {
    int queue[MAX_STATIONS];
    int front = 0, rear = 0;
    int level[MAX_STATIONS + 1];

    for (int i = 1; i <= n; i++) {
        level[i] = -1;
    }

    queue[rear++] = pocetak;
    level[pocetak] = 0;

    while (front < rear) {
        int isp = queue[front++];

        Node* temp = graph[isp].head;
        while (temp != NULL) {
            int ks = temp->station;
            if (level[ks] == -1) {
                level[ks] = level[isp] + 1;
                queue[rear++] = ks;
            }
            temp = temp->next;
        }
    }

    return level[kraj];
}

int main() {
    int N, M, S, T;
    printf("Unesite N, M, S i T: ");
    scanf("%d %d %d %d", &N, &M, &S, &T);
    if(N>=3 && M<2*pow(10,5)){
        initializeGraph(N);

    for (int i = 0; i < M; i++) {
        int U, V;
        printf("Unesite Ui i Vi: ");
        scanf("%d %d", &U, &V);
        addEdge(U, V);
    }

    int brbuseva = (bfs(S, T, N))/2;

    printf("Broj autobusa koji je potreban Aliks da bi stigla do cilja je: %d\n", brbuseva);
    }

    return 0;
}