#include <bits/stdc++.h>
using namespace std;

class Graf {
    int BrojStanica;
    vector<set<int>> adj;

public:
    Graf(int BrojStanica);
    void DodajIvicu(int v, int w);
    void FormirajNoviGraf();
    int NajmanjiBrojPresedanja(int pocetna, int cilj);
};

Graf::Graf(int BrojStanica) {
    this->BrojStanica = BrojStanica;
    adj.resize(BrojStanica);
}

void Graf::DodajIvicu(int v, int w) {
    adj[v].insert(w);
    adj[w].insert(v);
}

void Graf::FormirajNoviGraf() {
    vector<set<int>> noviAdj(BrojStanica);
    for (int i = 0; i < BrojStanica; i++) {
        for (int j : adj[i]) {
            for (int k : adj[j]) {
                if (k != i) {
                    noviAdj[i].insert(k);
                }
            }
        }
    }
    adj = noviAdj;
}

int Graf::NajmanjiBrojPresedanja(int pocetna, int cilj) {
    vector<bool> posecen(BrojStanica, false);
    vector<int> udaljenost(BrojStanica, 0);

    list<int> red;
    posecen[pocetna] = true;
    red.push_back(pocetna);

    while (!red.empty()) {
        int trenutna = red.front();
        red.pop_front();

        for (int sused : adj[trenutna]) {
            if (!posecen[sused]) {
                posecen[sused] = true;
                udaljenost[sused] = udaljenost[trenutna] + 1;
                red.push_back(sused);

                if (sused == cilj)
                    return udaljenost[sused];
            }
        }
    }
    return -1; // Ako put nije pronaden
}

int main() {
    int n, m, s, t;
    cin >> n >> m >> s >> t;

    Graf g(n);
    for (int i = 0; i < m; i++) {
        int u, v;
        cin >> u >> v;
        g.DodajIvicu(u - 1, v - 1);
    }

    g.FormirajNoviGraf();
    cout << g.NajmanjiBrojPresedanja(s - 1, t - 1) << endl;
    return 0;
}