#include <bits/stdc++.h>
using namespace std;

class Graf {
    int BrojStanica;
    vector<set<int>> adj;

public:
    Graf(int BrojStanica) : BrojStanica(BrojStanica), adj(BrojStanica) {}

    void DodajIvicu(int v, int w) {
        adj[v].insert(w);
        adj[w].insert(v);
    }

    int NajmanjiBrojPresedanja(int pocetna, int cilj) {
        vector<bool> posecen(BrojStanica, false);
        queue<pair<int, int>> red;
        red.push({pocetna, 0});
        posecen[pocetna] = true;

        while (!red.empty()) {
            int trenutna = red.front().first;
            int presedanja = red.front().second;
            red.pop();

            if (trenutna == cilj)
                return presedanja;

            for (int sused : adj[trenutna]) {
                for (int sekundarni : adj[sused]) {
                    if (!posecen[sekundarni]) {
                        red.push({sekundarni, presedanja + 1});
                        posecen[sekundarni] = true;
                    }
                }
            }
        }
        return -1; // Ako put nije pronaden
    }
};

int main() {
    int n, m, s, t;
    cin >> n >> m >> s >> t;
    Graf g(n);
    for (int i = 0; i < m; i++) {
        int u, v;
        cin >> u >> v;
        g.DodajIvicu(u - 1, v - 1);
    }
    cout << g.NajmanjiBrojPresedanja(s - 1, t - 1) << endl;
    return 0;
}