#include <iostream>
#include <vector>
#include <queue>
using namespace std;

int pretraga(int N, int M, vector<pair<int, int>> linije, int S, int T) {
    vector<vector<bool>> stari_plan(N + 1, vector<bool>(N + 1, false));
    for (auto linija : linije) {
        stari_plan[linija.first][linija.second] = true;
        stari_plan[linija.second][linija.first] = true;
    }

    vector<vector<bool>> novi_plan(N + 1, vector<bool>(N + 1, false));
    for (int i = 1; i <= N; i++) {
        for (int j = i + 1; j <= N; j++) {
            bool postoji_medjustanica = false;
            for (int k = 1; k <= N; k++) {
                if (k != i && k != j && stari_plan[i][k] && stari_plan[k][j]) {
                    postoji_medjustanica = true;
                    break;
                }
            }
            if (postoji_medjustanica) {
                novi_plan[i][j] = true;
                novi_plan[j][i] = true;
            }
        }
    }

    vector<int> rastojanje(N + 1, -1); 
    queue<int> red;
    rastojanje[S] = 0;
    red.push(S);
    while (!red.empty()) {
        int trenutna = red.front();
        red.pop();
        for (int i = 1; i <= N; i++) {
            if (novi_plan[trenutna][i] && rastojanje[i] == -1) {
                rastojanje[i] = rastojanje[trenutna] + 1; 
                red.push(i);
            }
        }
    }
    return rastojanje[T];
}

int main() {
    int N, M, S, T;
    cin >> N >> M >> S >> T;
    vector<pair<int, int>> linije(M);
    for (int i = 0; i < M; i++) {
        cin >> linije[i].first >> linije[i].second;
    }
    cout << pretraga(N, M, linije, S, T) << endl;
    return 0;
}