using System;
using System.Collections.Generic;

namespace PetljaTakmicenje3
{
    class Program
    {
        static int najmanjeStanica(int n, Dictionary<int, List<int>> linije, int s, int t)
        {
            Queue<int> queue = new Queue<int>();
            bool[] proso = new bool[n+1];
            int[] brojProlaza = new int[n+1];
            queue.Enqueue(s);
            proso[s] = true;

            while (queue.Count > 0)
            {
                int trenutno = queue.Dequeue();

                if(trenutno == t)
                {
                    return brojProlaza[trenutno];
                }

                foreach(int sledece in linije[trenutno])
                {
                    foreach(int spojnica in linije[sledece])
                    {
                        if (!proso[spojnica])
                        {
                            proso[spojnica] = true;
                            queue.Enqueue(spojnica);
                            brojProlaza[spojnica] = brojProlaza[trenutno] + 1;
                        }
                    }
                }
            }

            return -1;
        }
        static void Main(string[] args)
        {
            string[] input = Console.ReadLine().Split(' ');
            int n = int.Parse(input[0]);
            int m  = int.Parse(input[1]);
            int s = int.Parse(input[2]);
            int t = int.Parse(input[3]);
            var linije = new Dictionary<int, List<int>>();
            var novaLinija = new Dictionary<int, List<int>>();
            for(int i = 0; i < m; i++)
            {
                input = Console.ReadLine().Split(' ');
                int ui = int.Parse(input[0]);
                int vi = int.Parse(input[1]);
                if (!linije.ContainsKey(ui))
                {
                    linije[ui] = new List<int>();
                }
                if (!linije.ContainsKey(vi))
                {
                    linije[vi] = new List<int>();
                }
                linije[ui].Add(vi);
                linije[vi].Add(ui);
            }
            int brojStanijaPotrebno = najmanjeStanica(n,linije,s,t);
            Console.WriteLine(brojStanijaPotrebno);
        }
    }
}