#include <iostream>
#include <vector>
#include <queue>
#include <unordered_set>

using namespace std;

int bfs(const vector<vector<int>>& graph, int start, int end) {
    unordered_set<int> visited;
    queue<pair<int, int>> q;
    q.push({ start, 0 });

    while (!q.empty()) {
        int current = q.front().first;
        int transfers = q.front().second;
        q.pop();

        if (current == end) {
            return transfers;
        }

        visited.insert(current);

        for (int neighbor : graph[current]) {
            if (visited.find(neighbor) == visited.end()) {
                q.push({ neighbor, transfers + 1 });
            }
        }
    }

    return -1;
}

int mS(int N, int M, int S, int T, const vector<pair<int, int>>& pairs) {
    vector<vector<int>> graph(N + 1);

    for (const auto& pair : pairs) {
        graph[pair.first].push_back(pair.second);
        graph[pair.second].push_back(pair.first);
    }

    return bfs(graph, S, T);
}

int main() {
    int N, M, S, T;
    cin >> N >> M >> S >> T;

    vector<pair<int, int>> parovi(M);
    for (int i = 0; i < M; ++i) {
        cin >> parovi[i].first >> parovi[i].second;
    }

    int result = mS(N, M, S, T, parovi);
    cout << result / 2;

    
}