#include <iostream>
#include <vector>
using namespace std;
int bfs(const vector<vector<int>>& matrica, int pocetak, int kraj) {
    unordered_set<int> poseceni;
    queue<pair<int, int>> q; q.push({ pocetak, 0 });
    while (!q.empty()) {
        int c = q.front().first;
        int t = q.front().second; q.pop();
        if (c == kraj) return t;
        poseceni.insert(c);
        for (int neighbor : matrica[c]) {
            if (poseceni.find(neighbor) == poseceni.end()) {
                q.push({ neighbor, t + 1 });
            }
        }
    }
    return -1;
}
int mS(int N, int M, int S, int T, const vector<pair<int, int>>& parovi) {
    vector<vector<int>> matrica(N + 1);
    for (const auto& par : parovi) {
       matrica[par.first].push_back(par.second);
       matrica[par.second].push_back(par.first);
    }
    return bfs(matrica, S, T);
}
int main() {
    ios_base::sync_with_stdio(false);cin.tie(0);cout.tie(0);
    int n, m, s, t;cin >> n >> m >> s >> t;
    vector<pair<int, int>> parovi(m);
    for (int i = 0; i < m; ++i) {
        cin >> parovi[i].first >> parovi[i].second;
    }
    cout << mS(n, m, s, t, parovi) / 2;
}