#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

int pretrazi(vector<pair<int, int>> parovi, int start, int end) {
    vector<bool> poseceno(parovi.size(), false);
    vector<pair<int, int>> red;
    red.push_back({ start, 0 });

    while (!red.empty()) {
        int trenutnaStanica = red.front().first;
        int presedanja = red.front().second;
        red.erase(red.begin());

        if (trenutnaStanica == end) {
            return presedanja / 2;
        }

        poseceno[trenutnaStanica] = true;

        for (int i = 0; i < parovi.size(); ++i) {
            if (!poseceno[i] && (parovi[i].first == trenutnaStanica || parovi[i].second == trenutnaStanica)) {
                int sledecaStanica = (parovi[i].first == trenutnaStanica) ? parovi[i].second : parovi[i].first;
                red.push_back({ sledecaStanica, presedanja + 1 });
            }
        }

        sort(red.begin(), red.end(), [](pair<int, int> a,pair<int, int> b) {
            return a.second < b.second;
            });
    }

    return -1;
}

int main() {
    int n, m, s, t;
    cin >> n >> m >> s >> t;

    vector<pair<int, int>> parovi(m);
    for (int i = 0; i < m; ++i) {
        cin >> parovi[i].first >> parovi[i].second;
    }

    int rezultat = pretrazi(parovi, s, t);
    cout << rezultat;

}