def min_autobusa_do_destinacije(BrojStanica, BrojLinija, PolaznaStanica, KrajnjaStanica, Linije):
    # Pravimo graf na osnovu starih autobuskih linija
    graf = {i: set() for i in range(1, BrojStanica + 1)}
    for linija in Linije:
        graf[linija[0]].add(linija[1])
        graf[linija[1]].add(linija[0])

    # Funkcija koja racuna najmanji broj autobusa koji su joj potrebni
    def bfs(pocetak, cilj):
        poseceno = set()
        red = [(pocetak, 0)]

        while red:
            trenutna, autobusi_korisceni = red.pop(0)
            poseceno.add(trenutna)

            if trenutna == cilj:
                return autobusi_korisceni

            for sused in graf[trenutna]:
                if sused not in poseceno:
                    red.append((sused, autobusi_korisceni + 1))

        return float('inf')

    # Pozivamo BFS funkciju
    rezultat = bfs(PolaznaStanica, KrajnjaStanica)

    return rezultat if rezultat != float('inf') else -1

# Citanje ulaznih podataka
BrojStanica, BrojLinija, PolaznaStanica, KrajnjaStanica = map(int, input().split())
Linije = [tuple(map(int, input().split())) for _ in range(BrojLinija)]

# Pozivanje funkcije i ispis rezultata
rezultat = min_autobusa_do_destinacije(BrojStanica, BrojLinija, PolaznaStanica, KrajnjaStanica, Linije)
print(rezultat/2)