from collections import defaultdict, deque

def najmanji_broj_autobusa(N, M, S, T, autobusi):
    # Formiraj graf na osnovu starog plana
    graf = defaultdict(list)
    for autobus in autobusi:
        graf[autobus[0]].append(autobus[1])
        graf[autobus[1]].append(autobus[0])

    # BFS za pronalaženje najkraceg puta od stanice S do stanice T
    posetili = set()
    red = deque([(S, 0)])  # (stanica, broj_autobusa)
    posetili.add(S)

    while red:
        trenutna_stanica, broj_autobusa = red.popleft()

        if trenutna_stanica == T:
            return broj_autobusa

        for susedna_stanica in graf[trenutna_stanica]:
            if susedna_stanica not in posetili:
                posetili.add(susedna_stanica)
                red.append((susedna_stanica, broj_autobusa + 1))

    return -1  # Ako nije pronaden put od S do T

# Ucitavanje ulaznih podataka
N, M, S, T = map(int, input().split())
autobusi = [tuple(map(int, input().split())) for _ in range(M)]

# Rešavanje zadatka
rezultat = najmanji_broj_autobusa(N, M, S, T, autobusi)

# Ispisivanje rezultata
print(rezultat)