#include <bits/stdc++.h>

using namespace std;

void dodaj(vector<int> adj[], int u, int v) {
    adj[u].push_back(v);
    adj[v].push_back(u);
}

bool povezano(vector<int> adj[], int u, int v) {
    for (int x : adj[u]) {
        if (x == v) {
            return true;
        }
    }
    return false;
}

int sdot(vector<int> adj[], int n, int s, int t) {
    vector<int> distanca(n + 1, -1);
    queue<int> q;

    distanca[s] = 0;
    q.push(s);

    while (!q.empty()) {
        int u = q.front();
        q.pop();

        for (int v : adj[u]) {
            if (distanca[v] == -1) {
                distanca[v] = distanca[u] + 1;
                q.push(v);

                if (v == t) {
                    return distanca[v];
                }
            }
        }
    }

    return -1;
}

int main(){
    int n,m,s,t;
    vector<int> adj[200001];
    cin >> n >> m >> s >> t;
    int x,y;
    for(int i=0;i<m;i++){
        cin >> x >> y;
        dodaj(adj, x, y);
    }

    vector<vector<int>> novi(n+1, vector<int>(n+1, 0));

    for (int a = 1; a <= n; ++a) {
        for (int b = a + 1; b <= n; ++b) {
            for (int c = 1; c <= n; ++c) {
                if (povezano(adj, a, c) && povezano(adj, b, c)) {
                    novi[a][b] = 1;
                    novi[b][a] = 1;
                    break;
                }
            }
        }
    }

    int distanca = sdot(novi, n, s, t);

    cout << distanca;
}