using System;
using System.Collections.Generic;

class Program
{
    static void Main()
    {
        string[] input = Console.ReadLine().Split();
        int N = int.Parse(input[0]);
        int M = int.Parse(input[1]);
        int S = int.Parse(input[2]);
        int T = int.Parse(input[3]);

        Dictionary<int, List<int>> graph = new Dictionary<int, List<int>>();

        for (int i = 0; i < M; i++)
        {
            input = Console.ReadLine().Split();
            int U = int.Parse(input[0]);
            int V = int.Parse(input[1]);

            if (!graph.ContainsKey(U))
                graph[U] = new List<int>();

            if (!graph.ContainsKey(V))
                graph[V] = new List<int>();

            graph[U].Add(V);
            graph[V].Add(U);
        }

        int result = MinTransfers(N, graph, S, T);
        Console.WriteLine(result/2);
    }

    static int MinTransfers(int N, Dictionary<int, List<int>> graph, int start, int end)
    {
        Queue<int> queue = new Queue<int>();
        HashSet<int> visited = new HashSet<int>();

        queue.Enqueue(start);
        visited.Add(start);

        int transfers = 0;

        while (queue.Count > 0)
        {
            int size = queue.Count;

            for (int i = 0; i < size; i++)
            {
                int current = queue.Dequeue();

                if (current == end)
                    return transfers;

                foreach (int neighbor in graph[current])
                {
                    if (!visited.Contains(neighbor))
                    {
                        queue.Enqueue(neighbor);
                        visited.Add(neighbor);
                    }
                }
            }

            transfers++;
        }

        return -1;
    }
}