#include <iostream>
#include <vector>
#include <queue>
#include <utility>

using namespace std;

int presedanje(vector<vector<int> > stanice, int s, int t) {
	bool predjeneStanice[stanice.size()] = {};
	queue<pair<int, int> > put;
	put.push(make_pair(s, 0));
	predjeneStanice[s-1] = true;
	
	while(!put.empty()) {
		int trenutnaStanica = put.front().first,
		    predjenPut = put.front().second;
		
		for(int i = 0; i < stanice[trenutnaStanica-1].size(); i++) {
			if(stanice[trenutnaStanica-1][i] == t)
				return predjenPut / 2 + 1;
			if(!predjeneStanice[stanice[trenutnaStanica-1][i]-1]) {
				put.push(make_pair(stanice[trenutnaStanica-1][i], predjenPut+1));
				predjeneStanice[stanice[trenutnaStanica-1][i]-1] = true;
			}
		}
		put.pop();
	}
	
	// do ovoga nebi trebalo da dodje zbog prirode zadatka
	return 0;
}

int main() {
	ios_base::sync_with_stdio(false);
	
	int n, m, s, t;
	cin >> n >> m >> s >> t;
	
	vector<vector<int> > stanice(n, vector<int>());
	for(int i = 0; i < m; i++) {
		int a, b;
		cin >> a >> b;
		
		stanice[a-1].push_back(b);
		stanice[b-1].push_back(a);
	}
	
	cout << presedanje(stanice, s, t) << endl;
	
	return 0;
}