#include <iostream>
#include <vector>
#include <queue>

using namespace std;

int bfs(int v, int trazeni, vector<vector<int>>& graf) {
    
    int n = graf.size();
    vector<int> posecen(n);
    for (int i = 0; i < n; i++) {
        posecen[i] = -1;
    }
    queue<int> q;

    q.push(v);
    posecen[v]++;

    while (!q.empty()) {
        int t = q.front();
        q.pop();

        for (int u : graf[t]) {
            if (posecen[u] == -1) {
                q.push(u);
                posecen[u] = posecen[t] + 1;
            }
        }
    }
    return posecen[trazeni];
}


int main() {
	int n, m, s, t;
	cin >> n >> m >> s >> t;

    vector<vector<int>> graf(n);
    for (int i = 0; i < m; i++) {
        int a, b;
        cin >> a >> b;
        a--;
        b--;
        graf[a].push_back(b);
        graf[b].push_back(a);
    }
    
    int rez = bfs(s - 1, t - 1, graf);

    cout << rez / 2 << endl;

    return 0;
}