#include <iostream>
#include <vector>

using namespace std;

int main() {
    int N, M, S, T;
    cin >> N >> M >> S >> T;

    vector<vector<int>> graph(N + 1, vector<int>());

    for (int i = 0; i < M; ++i) {
        int U, V;
        cin >> U >> V;
        graph[U].push_back(V);
        graph[V].push_back(U);
    }

    vector<int> distance(N + 1, -1);
    vector<int> queue;

    distance[S] = 0;
    queue.push_back(S);

    for (int qIndex = 0; qIndex < queue.size(); ++qIndex) {
        int current = queue[qIndex];

        for (int neighbor : graph[current]) {
            if (distance[neighbor] == -1) {
                distance[neighbor] = distance[current] + 1;
                queue.push_back(neighbor);
            }
        }
    }

    if (distance[T] == -1) {
        cout << "-1\n";
        return 0;
    }

    int minTransfers = N;

    for (int station = 1; station <= N; ++station) {
        if (graph[station].empty()) {
            continue;
        }

        int transfers = 0;

        if (distance[station] <= distance[S]) {
            transfers += distance[S] - distance[station];
        } else {
            transfers += distance[station] - distance[S];
        }

        if (distance[station] <= distance[T]) {
            transfers += distance[T] - distance[station];
        } else {
            transfers += distance[station] - distance[T];
        }

        minTransfers = min(minTransfers, transfers);
    }

    cout << minTransfers/2 << "\n";

    return 0;
}