#include <iostream>
#include <vector>
#include <queue>

using namespace std;

const int MAXN = 1005;

vector<int> graph[MAXN];
bool visited[MAXN];

int bfs(int start, int end, int M) {
    queue<pair<int, int> > q;
    q.push({start, 0});
    visited[start] = true;
    int min_depth = M;
    while (!q.empty()) {
        int current = q.front().first;
        int depth = q.front().second;
        q.pop();

        if (current == end && depth < min_depth) {
            min_depth = depth;
        }

        for (int i = 0; i < graph[current].size(); ++i) {
            int neighbor = graph[current][i];
            if (!visited[neighbor]) {
                visited[neighbor] = true;
                q.push({neighbor, depth + 1});
            }
        }
    }
    return min_depth;

    return -1;
}

int main() {
    int N, M, S, T;
    cin >> N >> M >> S >> T;

    for (int i = 0; i < M; ++i) {
        int U, V;
        cin >> U >> V;
        graph[U].push_back(V);
        graph[V].push_back(U);
    }

    int minBuses = bfs(S, T, M);
    if(minBuses % 2 != 0){
    	cout << minBuses / 2 + 1 << endl;
	}
	else{
    cout << minBuses / 2 << endl;
}

    return 0;
}