#include <stdio.h>
#include <stdlib.h>
struct Cvor
{
    int destinacija;
    struct Cvor* sledeci;
};
struct Graf
{
    int brstanica;
    struct Cvor** lista_susedstva;
};
void dodajGranu(struct Graf* graf, int pocetna_stanica, int odrediste)
{
    struct Cvor* noviCvor=(struct Cvor*)malloc(sizeof(struct Cvor));
    noviCvor->destinacija=odrediste;
    noviCvor->sledeci=graf->lista_susedstva[pocetna_stanica];
    graf->lista_susedstva[pocetna_stanica]=noviCvor;
    noviCvor=(struct Cvor*)malloc(sizeof(struct Cvor));
    noviCvor->destinacija=pocetna_stanica;
    noviCvor->sledeci=graf->lista_susedstva[odrediste];
    graf->lista_susedstva[odrediste]=noviCvor;
}
int izracunaj_buseve(struct Graf* graf, int pocetak, int kraj)
{
    int* stajanja=(int*)malloc(graf->brstanica*sizeof(int));
    for(int i=0;i<graf->brstanica;i++)
        stajanja[i] = 0;
    int busevi=0, trenutna_stanica=pocetak;
    stajanja[trenutna_stanica]=1;
    while(trenutna_stanica!=kraj)
    {
        struct Cvor* trenutni_cvor=graf->lista_susedstva[trenutna_stanica];
        while(trenutni_cvor!=NULL)
        {
            if(!stajanja[trenutni_cvor->destinacija])
            {
                stajanja[trenutni_cvor->destinacija]=1;
                trenutna_stanica=trenutni_cvor->destinacija;
                busevi++;
                break;
            }
            trenutni_cvor=trenutni_cvor->sledeci;
        }
    }
    free(stajanja);
    return busevi;
}

int main()
{
    int N, M, S, T;
    scanf("%d %d %d %d", &N, &M, &S, &T);
    struct Graf* graf = (struct Graf*)malloc(sizeof(struct Graf));
    graf->brstanica=N;
    graf->lista_susedstva=(struct Cvor**)malloc(N*sizeof(struct Cvor*));
    for(int i=0;i<N;i++)
        graf->lista_susedstva[i]=NULL;
    for(int i=0;i<M;i++)
    {
        int Ui, Vi;
        scanf("%d %d", &Ui, &Vi);
        dodajGranu(graf, Ui, Vi);
    }
    int broj_autobusa=izracunaj_buseve(graf, S, T);
    printf("%d\n", broj_autobusa);
    free(graf->lista_susedstva);
    free(graf);
    return 0;
}