#include <iostream>
#include <vector>
#include <queue>
#include <unordered_set>
using namespace std;
vector<vector<int>> buildNewPlan(int N, int M, const vector<pair<int, int>>& oldPlan) {
    vector<vector<int>> newPlan(N + 1);

    for (const auto& edge : oldPlan) {
        int U = edge.first;
        int V = edge.second;
        newPlan[U].push_back(V);
        newPlan[V].push_back(U);
    }

    return newPlan;
}
int minBusesToDestination(int N, const vector<vector<int>>& newPlan, int start, int destination) {
    unordered_set<int> visited;
    queue<pair<int, int>> q; 
    q.push({ start, 0 });
    visited.insert(start);
    while (!q.empty()) {
        int currentStation = q.front().first;
        int busesUsed = q.front().second;
        q.pop();
        if (currentStation == destination) {
            return busesUsed;
        }
        for (int neighbor : newPlan[currentStation]) {
            if (visited.find(neighbor) == visited.end()) {
                q.push({ neighbor, busesUsed + 1 });
                visited.insert(neighbor);
            }
        }
    }
    return -1;
}

int main() {
    int N, M, S, T;
    cin >> N >> M >> S >> T;
    vector<pair<int, int>> oldPlan(M);
    for (int i = 0; i < M; ++i) {
        cin >> oldPlan[i].first >> oldPlan[i].second;
    }
    vector<vector<int>> newPlan = buildNewPlan(N, M, oldPlan);
    int result = minBusesToDestination(N, newPlan, S, T);
    cout << result/2 << endl;
    return 0;
}