#include <bits/stdc++.h>

using namespace std;
 
const int INF = 1e9;

int odd(int x) 
{
	return x * 10 + 1;
}

int even(int x)
{
	return x * 10 + 2;
} 

int dijkstra(int source,int destination, vector<vector<int>> adj, vector<int> dist)
{
 
    priority_queue<pair<int, int>, vector<pair<int, int> >, greater<pair<int, int> > > pq;
 
    pq.push({ 0, even(source) });
    dist[even(source)] = 0;
 
    while (!pq.empty()) 
	{
		int u = pq.top().second;
        pq.pop();
        
        for (int p : adj[u]) 
		{
            int v = p;

            if (dist[u] + 1 < dist[v]) 
			{
 
                dist[v] = dist[u] + 1;
                pq.push({ dist[v], v });
            }
        }
    }
    
    return dist[even(destination)];
}

int main()
{
	ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    
	int n,m,s,t;
	cin >> n >> m >> s >> t;
	
	vector<vector<int>> adj(n * 10 + 3);
	vector<int> dist(n * 10 + 3, INF);
	
	int u,v;
	
	for(int i=0;i<m;i++)
	{
		cin >> u >> v;	
			
		adj[even(u)].push_back(odd(v));
    	adj[odd(u)].push_back(even(v));
    	adj[odd(v)].push_back(even(u));
    	adj[even(v)].push_back(odd(u));
	}

    cout << dijkstra(s,t,adj, dist)/2;
 
    return 0;
}