#include <bits/stdc++.h>
#define MAX_N 503

using namespace std;

bool old_graph[MAX_N][MAX_N];
vector<int> new_graph[MAX_N];

int bfs(int n, int s, int t) {
    int d[MAX_N];
    fill(d, d + n, -1);

    priority_queue<pair<int, int>> q;
    q.push({s, 0});
    
    while(!q.empty()) {
        pair<int, int> curr_node = q.top();
        q.pop();
        d[curr_node.first] = curr_node.second;
        for(auto iter_node : new_graph[curr_node.first]) {
            if(d[iter_node] == -1) {
                q.push({iter_node, d[curr_node.first] + 1});
            }
        }
    }
    return d[t];
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);
    int n, m, s, t;
    cin >> n >> m >> s >> t;
    s--;
    t--;
    for(int i = 0; i < m; i++) {
        int a, b;
        cin >> a >> b;
        a--;
        b--;
        old_graph[a][b] = true;
        old_graph[b][a] = true;
    }
    for(int i = 0; i < n; i++) {
        for(int k = i + 1; k < n; k++) {
            bool constructed = false;
            for(int j = 0; j < n && !constructed; j++) {
                if(i != j && k != j && old_graph[i][j] && old_graph[j][k]) {
                    new_graph[i].push_back(k);
                    new_graph[k].push_back(i);
                    constructed = true;
                }
            }
        }
    }
    int ans = bfs(n, s, t);
    cout << ans;
    return 0;
}