#include <iostream>
#include <vector>
#include <queue>
#include <stack>
#include <algorithm>

using namespace std;

class graf
{
public:
    int c;
    int l;
    vector <int> *kom;
    vector <int> *starekom;
    graf(int brojCvorova,int brojLinija)
    {
        this->c = brojCvorova;
        this->l = brojLinija;
        this->starekom = new vector <int> [brojLinija];
        this->kom = new vector <int> [brojLinija];
    }
    void dodajLiniju(int v, int u)
    {
        starekom[v-1].push_back(u-1);
        starekom[u-1].push_back(v-1);
        for(int i=0; i<starekom[v-1].size(); i++)
        {
            if(starekom[v-1][i]!=u-1)
            {
                kom[u-1].push_back(starekom[v-1][i]);
                kom[starekom[v-1][i]].push_back(u-1);
            }

        }

        for(int i=0; i<starekom[u-1].size(); i++)
        {
            if(starekom[u-1][i]!=v-1)
            {
                kom[starekom[u-1][i]].push_back(v-1);
                kom[v-1].push_back(starekom[u-1][i]);
            }
        }

    }



    void BFS(int pocetak,int kraj,vector<int> &distanca, vector<int> &rod)
    {
        vector<bool> poscn(c, 0);
        queue<int> q;
        q.push(pocetak);
        poscn[pocetak] = 1;
        while(!q.empty())
        {
            int q_size = q.size();
            while(q_size--)
            {
                int cvor = q.front();
                q.pop();
                poscn[cvor] = 1;
                for(int komsija : this->kom[cvor])
                {
                    if(!poscn[komsija])
                    {
                        poscn[komsija] = 1;
                        distanca[komsija] = distanca[cvor] + 1;
                        rod[komsija] = cvor;
                        q.push(komsija);
                    }
                }
            }
        }
    }

    void najkraciPut(int pocetak, int kraj)
    {
        vector<int> distanca(c, 0);
        vector<int> rod(c);
        for(int i=0; i<c; ++i)
        {
            rod[i] = i;
        }
        BFS(pocetak, kraj, distanca, rod);
        stack<int> st;
        while(rod[kraj]!=kraj)
        {
            st.push(kraj);
            kraj = rod[kraj];
        }
        st.push(kraj);
        int duzinaPuta = st.size();
        cout<<duzinaPuta-1;
    }



};
int main()
{
    int n,m,s,t;
    cin>>n>>m>>s>>t;
    graf G(n,m);
    for(int i=0; i<m; i++)
    {
        int temp1,temp2;
        cin>>temp1>>temp2;
        G.dodajLiniju(temp1,temp2);
    }

    G.najkraciPut(s-1,t-1);




}