using System;
using System.Collections.Generic;

class Program
{
    class StationInfo
    {
        public int Station { get; set; }
        public int NumRoadsSoFar { get; set; }
    }
    static void Main()
    {
        string line1 = Console.ReadLine()+" ";
        string numStationsS = line1.Substring(0,line1.IndexOf(' '));
        int numStations = Convert.ToInt32(numStationsS);
        line1 = line1.Remove(0, numStationsS.Length + 1);
        string numRoadsS = line1.Substring(0, line1.IndexOf(' '));
        int numRoads = Convert.ToInt32(numRoadsS);
        line1 = line1.Remove(0, numRoadsS.Length + 1);
        string startStationS = line1.Substring(0, line1.IndexOf(' '));
        int startStation = Convert.ToInt32(startStationS);
        line1 = line1.Remove(0, startStationS.Length + 1);
        string endStationS = line1.Substring(0, line1.IndexOf(' '));
        int endStation = Convert.ToInt32(endStationS);
        int[,] roads = new int[numRoads,2];
        for (int i = 0; i < numRoads; i++)
        {
            string newLine = Console.ReadLine() + " ";
            for (int j = 0; j < 2; j++)
            {
                string newLineSub = newLine.Substring(0, newLine.IndexOf(' '));
                roads[i,j] = Convert.ToInt32(newLineSub);
                newLine = newLine.Remove(0, newLineSub.Length + 1);
            }
        }
        int[,] newRoads = ConstructNewRoads(numStations, numRoads, roads);
        int result = MinRoadsToDestination(numStations, numRoads, startStation, endStation, newRoads);
        Console.WriteLine(result);
    }

    static int[,] ConstructNewRoads(int numStations, int numRoads, int[,] oldRoads)
    {
        HashSet<int> stations = new HashSet<int>();
        Dictionary<int, HashSet<int>> adjacencyList = new Dictionary<int, HashSet<int>>();

        // Create an adjacency list based on the old roads
        for (int i = 0; i < numRoads; i++)
        {
            int station1 = oldRoads[i, 0];
            int station2 = oldRoads[i, 1];

            if (!adjacencyList.ContainsKey(station1))
                adjacencyList[station1] = new HashSet<int>();

            if (!adjacencyList.ContainsKey(station2))
                adjacencyList[station2] = new HashSet<int>();

            adjacencyList[station1].Add(station2);
            adjacencyList[station2].Add(station1);

            stations.Add(station1);
            stations.Add(station2);
        }

        HashSet<Tuple<int, int>> newRoadsSet = new HashSet<Tuple<int, int>>();

        // Construct new roads based on the adjacency list
        foreach (int station1 in stations)
        {
            foreach (int station2 in stations)
            {
                if (station1 != station2 && !adjacencyList[station1].Contains(station2))
                {
                    foreach (int intermediateStation in adjacencyList[station1])
                    {
                        if (adjacencyList[intermediateStation].Contains(station2))
                        {
                            // Ensure the road is not counted twice
                            Tuple<int, int> newRoad = Tuple.Create(Math.Min(station1, station2), Math.Max(station1, station2));
                            newRoadsSet.Add(newRoad);
                            break;
                        }
                    }
                }
            }
        }

        // Convert the set of new roads to a 2D array
        int[,] newRoads = new int[newRoadsSet.Count, 2];
        int index = 0;
        foreach (Tuple<int, int> road in newRoadsSet)
        {
            newRoads[index, 0] = road.Item1;
            newRoads[index, 1] = road.Item2;
            index++;
        }

        return newRoads;
    }
    static int MinRoadsToDestination(int numStations, int numRoads, int start, int end, int[,] roads)
    {
        Dictionary<int, List<int>> graph = new Dictionary<int, List<int>>();
        for (int i = 0; i < numRoads; i++)
        {
            int station1 = roads[i, 0];
            int station2 = roads[i, 1];

            if (!graph.ContainsKey(station1))
                graph[station1] = new List<int>();

            if (!graph.ContainsKey(station2))
                graph[station2] = new List<int>();

            graph[station1].Add(station2);
            graph[station2].Add(station1);
        }

        HashSet<int> visited = new HashSet<int>();
        Queue<StationInfo> queue = new Queue<StationInfo>();
        queue.Enqueue(new StationInfo { Station=start,NumRoadsSoFar=0});

        while (queue.Count > 0)
        {
            StationInfo currentStationInfo = queue.Dequeue();

            if (currentStationInfo.Station == end)
                return currentStationInfo.NumRoadsSoFar;

            if (!visited.Contains(currentStationInfo.Station))
            {
                visited.Add(currentStationInfo.Station);
                foreach (int neighbor in graph[currentStationInfo.Station])
                {
                    queue.Enqueue(new StationInfo { Station = neighbor, NumRoadsSoFar = currentStationInfo.NumRoadsSoFar + 1 });
                }
            }
        }
        return -1;
    }
}