#include <iostream>
#include <vector>
#include <queue>

using namespace std;

int main() {
    int brojStanica, brojLinija, polaznaStanica, ciljnaStanica;
    cin >> brojStanica >> brojLinija >> polaznaStanica >> ciljnaStanica;

    vector<vector<int>> graf(brojStanica + 1); // Lista povezanosti grafa

    for (int i = 0; i < brojLinija; ++i) {
        int U, V;
        cin >> U >> V;
        graf[U].push_back(V);
        graf[V].push_back(U);
    }

    vector<int> udaljenost(brojStanica + 1, -1); // Niz udaljenosti za cuvanje minimalne udaljenosti do svakog cvora
    queue<int> red;

    udaljenost[polaznaStanica] = 0; // Pocetni cvor

    red.push(polaznaStanica);

    while (!red.empty()) {
        int trenutni = red.front();
        red.pop();

        for (int sused : graf[trenutni]) {
            if (udaljenost[sused] == -1) {
                udaljenost[sused] = udaljenost[trenutni] + 1;
                red.push(sused);
            }
        }
    }

    cout << udaljenost[ciljnaStanica]/2;

    return 0;
}