#include <stdio.h>
#include <stdlib.h>

struct Pair {
    int first;
    int second;
};

int comparePairs(const void *a, const void *b) {
    return ((struct Pair *)a)->first - ((struct Pair *)b)->first;
}

int main() {
    int N, M, S, T;
    scanf("%d %d %d %d", &N, &M, &S, &T);

    struct Pair *pairs = (struct Pair *)malloc(M * sizeof(struct Pair));

    for (int i = 0; i < M; i++) {
        scanf("%d %d", &pairs[i].first, &pairs[i].second);
    }

    qsort(pairs, M, sizeof(struct Pair), comparePairs);

    int numGroups = 0;
    int currentEnd = 0;

    // Provera da li je pocetna tacka ukljucena u neku od celina
    if (S <= pairs[0].first || S >= pairs[0].second) {
        numGroups++; // Ako pocetna tacka nije ukljucena u nijednu celinu, dodajemo jednu grupu
    }

    for (int i = 0; i < M; i++) {
        if (pairs[i].first > currentEnd + 1) {
            numGroups++;
            currentEnd = pairs[i].second;
        } else {
            if (pairs[i].second > currentEnd) {
                currentEnd = pairs[i].second;
            }
        }
    }

    printf("%d\n", numGroups);

    free(pairs);

    return 0;
}