#include <iostream>
#include <vector>
#include <queue>
#include <unordered_set>

using namespace std;

struct AutobuskaStanica {
    int id;
    vector<int> susedi;
};

int pronadjiMinAutobuse(const vector<AutobuskaStanica>& stanice, int pocetak, int kraj) {
    int ukupnoStanica = stanice.size();
    vector<bool> poseceno(ukupnoStanica, false);

    queue<int> red;
    red.push(pocetak);
    poseceno[pocetak] = true;

    int autobusi = 0;

    while (!red.empty()) {
        int trenutnaVelicina = red.size();

        for (int i = 0; i < trenutnaVelicina; ++i) {
            int trenutnaStanica = red.front();
            red.pop();

            if (trenutnaStanica == kraj) {
                return autobusi;
            }

            for (int sused : stanice[trenutnaStanica].susedi) {
                if (!poseceno[sused]) {
                    red.push(sused);
                    poseceno[sused] = true;
                }
            }
        }

        autobusi++;
    }

    return -1;
}

int main() {
    int brojStanica, brojLinija;
    cout << "Unesite broj stanica (N) i broj linija (M): ";
    cin >> brojStanica >> brojLinija;

    vector<AutobuskaStanica> stanice(brojStanica + 1);

    cout << "Unesite parove stanica koje su povezane linijom:\n";
    for (int i = 0; i < brojLinija; ++i) {
        int stanicaA, stanicaB;
        cin >> stanicaA >> stanicaB;
        stanice[stanicaA].susedi.push_back(stanicaB);
        stanice[stanicaB].susedi.push_back(stanicaA);
    }

    int pocetak, kraj;
    cout << "Unesite polaznu stanicu (S) i destinacionu stanicu (T): ";
    cin >> pocetak >> kraj;

    int rezultat = pronadjiMinAutobuse(stanice, pocetak, kraj);

    if (rezultat != -1) {
        cout << "Minimum broj autobusa koje morate uzeti: " << rezultat / 2 << endl;
    } else {
        cout << "Nemoguce je stici do destinacione stanice." << endl;
    }

    return 0;
}