#include <iostream>
#include <vector>
#include <queue>

using namespace std;

int main() {
    int N, M, S, T;
    cin >> N >> M >> S >> T;

    vector<vector<int>> k(N + 1);
    vector<vector<int>> s(N + 1);

    for (int i = 0; i < M; ++i) {
        int U, V;
        cin >> U >> V;
        s[U].push_back(V);
        s[V].push_back(U);
    }

    for (int i = 1; i <= N; ++i) {
        for (int j : s[i]) {
            for (int kom : s[j]) {
                k[i].push_back(kom);
            }
        }
    }

    vector<int> udaljenost(N + 1, -1);
    queue<int> red;

    udaljenost[S] = 0;
    red.push(S);

    while (!red.empty()) {
        int trenutna = red.front();
        red.pop();

        for (int komsija : k[trenutna]) {
            if (udaljenost[komsija] == -1) {
                udaljenost[komsija] = udaljenost[trenutna] + 1;
                red.push(komsija);
            }
        }
    }

    cout << udaljenost[T] << endl;

    return 0;
}