using System;
using System.Collections.Generic;
namespace petlja
{
    struct Cvor
    {
        public int indeks;
        public int prioritet;
        public Cvor(int i, int p)
        {
            indeks = i; prioritet = p;
        }
    }
    class PriorityQueue
    {
        private List<Cvor> heap;
        public PriorityQueue()
        {
            heap = new List<Cvor>();
        }
        public int Count => heap.Count;
        public void Enqueue(int indeks, int prioritet)
        {
            heap.Add(new Cvor(indeks, prioritet));
            int i = heap.Count - 1;
            while (i > 0)
            {
                int parent = (i - 1) / 2;
                if (heap[i].prioritet < heap[parent].prioritet)
                    Swap(i, i = parent);
                else
                    break;
            }
        }
        public Cvor Dequeue()
        {
            Cvor top = heap[0];
            heap[0] = heap[heap.Count - 1];
            heap.RemoveAt(heap.Count - 1);
            int i = 0;
            while (true)
            {
                int levoDete = 2 * i + 1;
                int desnoDete = 2 * i + 2;
                int najmanji = i;
                if (levoDete < heap.Count && heap[levoDete].prioritet < heap[najmanji].prioritet)
                    najmanji = levoDete;
                if (desnoDete < heap.Count && heap[desnoDete].prioritet < heap[najmanji].prioritet)
                    najmanji = desnoDete;
                if (najmanji != i)
                    Swap(i, i = najmanji);
                else
                    break;
            }
            return top;
        }
        private void Swap(int i, int j)
        {
            Cvor x = heap[i];
            heap[i] = heap[j];
            heap[j] = x;
        }
    }
    internal class Program
    {
        static void Main(string[] args)
        {
            string[] red = Console.ReadLine().Split();
            int n = int.Parse(red[0]), m = int.Parse(red[1]), s = int.Parse(red[2])-1, t = int.Parse(red[3])-1;
            List<int>[] a = new List<int>[n];
            for (int i = 0; i < n; i++)
                a[i] = new List<int>();
            for (int i = 0; i < m; i++)
            {
                red = Console.ReadLine().Split();
                a[int.Parse(red[0])-1].Add(int.Parse(red[1])-1);
                a[int.Parse(red[1])-1].Add(int.Parse(red[0])-1);
            }
            int[] shortestDistances = NajkraciPut(a, s);
            Console.WriteLine(Math.Ceiling(shortestDistances[t]/2.0));
        }
        static int[] NajkraciPut(List<int>[] graf, int s)
        {
            int[] udaljenosti = new int[graf.Length];
            bool[] posecen = new bool[graf.Length];
            for (int i = 0; i < graf.Length; i++)
                udaljenosti[i] = int.MaxValue;
            udaljenosti[s] = 0;
            PriorityQueue pQ = new PriorityQueue();
            pQ.Enqueue(s, 0);
            while (pQ.Count > 0)
            {
                Cvor pom = pQ.Dequeue();
                if (posecen[pom.indeks])
                    continue;
                posecen[pom.indeks] = true;
                foreach (var v in graf[pom.indeks])
                    if (!posecen[v] && pom.prioritet + 1 < udaljenosti[v])
                    {
                        udaljenosti[v] = pom.prioritet + 1;
                        pQ.Enqueue(v, udaljenosti[v]);
                    }
            }
            return udaljenosti;
        }
    }
}