#include <iostream>
#include <vector>
#include <queue>
#include <unordered_set>

using namespace std;

int findMinBuses(int N, int M, int S, int T, vector<vector<int>>& adj) {
    vector<int> dist(N + 1, -1);
    queue<int> q;
    dist[S] = 0;
    q.push(S);
    while (!q.empty()) {
        int current = q.front();
        q.pop();
        for (int neighbor : adj[current]) {
            if (dist[neighbor] == -1) {
                dist[neighbor] = dist[current] + 1;
                q.push(neighbor);
            }
        }
    }
    return dist[T];
}

int main() {
    int N, M, S, T;
    cin >> N >> M >> S >> T;
    vector<vector<int>> adj(N + 1);
    for (int i = 0; i < M; ++i) {
        int U, V;
        cin >> U >> V;
        adj[U].push_back(V);
        adj[V].push_back(U);
    }
    int minBuses = findMinBuses(N, M, S, T, adj);
    cout << minBuses / 2 << endl;
    return 0;
}