#include <iostream>
#include <unordered_set>
#include <vector>
#include <queue>
using namespace std;

int bfs(const unordered_set<unsigned int> *stanice, int start, int end, int N) {
    vector<bool> visited(N, false);
    queue<pair<int, int>> q; 
    q.push({start, 0});
    visited[start] = true;

    while (!q.empty()) {
        int current = q.front().first;
        int steps = q.front().second;
        q.pop();

        if (current == end) {
            return steps;
        }

        for (int neighbor : stanice[current]) {
            if (!visited[neighbor]) {
                q.push({neighbor, steps + 1});
                visited[neighbor] = true;
            }
        }
    }
    return -1;
    
}
int main()
{
    int N, M, S, T;
    cin >> N >> M >> S >> T;
    N++;
    unordered_set<unsigned int> *stanice = new unordered_set<unsigned int>[N];
    unordered_set<unsigned int> *nove_stanice = new unordered_set<unsigned int>[N];

    unsigned int A, B;
    for (int i = 0; i < M; i++)
    {
        cin >> A >> B;
        stanice[A].insert(B);
        stanice[B].insert(A);
    }
    for (int A = 0; A < N; A++)
    {
        unordered_set<unsigned int> temp_stanice; 
        for (int B : stanice[A])
        {
            for (int C : stanice[B])
            {
                if(A!=C)temp_stanice.insert(C);
            }
        }
        nove_stanice[A].insert(temp_stanice.begin(), temp_stanice.end());
        for(int temp_stanica: temp_stanice){
            nove_stanice[temp_stanica].insert(A);
        }
    }

    for (int i = 0; i < N; i++){stanice[i].insert(nove_stanice[i].begin(), nove_stanice[i].end());}
    cout << bfs(stanice, S , T , N );
    delete[] stanice;
    delete[] nove_stanice;

    return 0;
}