#include <iostream>
#include <vector>
#include <queue>
using namespace std;

struct Graph
{
	int v;
	vector<vector<int> > adj;
	vector<bool> visited;
};

void init_graph(Graph &g,int n)
{
	g.v=n;
	g.adj.resize(n);
	g.visited.resize(n,false);
}

void addEdge(Graph &g, int u,int v)
{
	g.adj[u].push_back(v);
	g.adj[v].push_back(u);
}

int BFS(Graph &g,int starty,int endy)
{
	queue<int> q;
	queue<int> val;
	q.push(starty);
	val.push(0);
	g.visited[starty]=true;
	while(!q.empty())
	{
		int pom=q.front();
		int pomval=val.front();
		q.pop();
		val.pop();
		if(pom==endy)
		{
			return pomval;
		}
		
		for(int i=0;i<g.adj[pom].size();i++)
		{
			if(!g.visited[g.adj[pom][i]])
			{
				g.visited[g.adj[pom][i]]=true;
				q.push(g.adj[pom][i]);
				val.push(pomval+1);
			}
		}
		
	}
	
	
}


int main(int argc, char** argv) {
	ios_base::sync_with_stdio(false);
	int n,m,s,e;
	cin >>n>>m>>s>>e;
	Graph g;
	init_graph(g,n);
	for(int i=0;i<m;i++)
	{
		int u,v;
		cin >>u>>v;
		addEdge(g,u-1,v-1);
	}
	
	cout <<(BFS(g,s-1,e-1)+1)/2<<"\n";
	
	return 0;
}