from collections import deque
def bfs(start, target, graph):
    queue = deque()
    queue.append((start, 0))
    visited = set([start])
    while queue:
        current_node, transfers = queue.popleft()
        if current_node == target:
            return transfers // 2  
        for neighbor in graph[current_node]:
            if neighbor not in visited:
                visited.add(neighbor)
                queue.append((neighbor, transfers + 1))
    return -1
def main():
    nodes, edges, start, target = map(int, input().split())
    graph = [[] for _ in range(nodes + 1)]
    for _ in range(edges):
        u, v = map(int, input().split())
        graph[u].append(v)
        graph[v].append(u)
    min_transfers = bfs(start, target, graph)
    print(min_transfers)
if __name__ == "__main__":
    main()