using System;
using System.Collections.Generic;

class AutobuskeStanice
{
    public int BrojStanica { get; private set; }
    private HashSet<int>[] povezaneStanice;

    public AutobuskeStanice(int dimenzija)
    {
        BrojStanica = dimenzija;
        povezaneStanice = new HashSet<int>[dimenzija];
    }

    public void Dodaj(int a, int b)
    {
        a--; b--;
        if (povezaneStanice[a] == null)
        {
            povezaneStanice[a] = new HashSet<int>();
        }
        if (povezaneStanice[b] == null)
        {
            povezaneStanice[b] = new HashSet<int>();
        }

        povezaneStanice[a].Add(b);
        povezaneStanice[b].Add(a);
    }

    public int Rastojanje(int a, int b)
    {
        a--; b--;
        var stanicaIRastojanje = new Queue<Tuple<int, int>>();

        var obidjeniBusevi = new bool[BrojStanica];
        var obidjeneStanice = new bool[BrojStanica];

        stanicaIRastojanje.Enqueue(Tuple.Create(a, 0));

        while (stanicaIRastojanje.Count > 0)
        {
            var trenutni = stanicaIRastojanje.Dequeue();
            var stanica = trenutni.Item1;
            var rastojanje = trenutni.Item2;

            if (stanica == b)
            {
                return rastojanje;
            }
            foreach (var s in povezaneStanice[stanica])
            {
                if (obidjeniBusevi[s]) { continue; }
                obidjeniBusevi[s] = true;
                foreach (var rute in povezaneStanice[s])
                {
                    if (obidjeneStanice[rute]) { continue; }
                    obidjeneStanice[rute] = true;
                    stanicaIRastojanje.Enqueue(Tuple.Create(rute, rastojanje + 1));
                }
            }
        }

        return -1;
    }
}

class Program
{
    static void Main()
    {
        var ulaz = Array.ConvertAll(Console.ReadLine().Split(' '), int.Parse);

        var dimenzija = ulaz[0];
        var brojVeza = ulaz[1];
        var pocetnaStanica = ulaz[2];
        var krajnjaStanica = ulaz[3];

        var autobuskeStanice = new AutobuskeStanice(dimenzija);

        for(int i = 0; i < brojVeza; i++)
        {
            var veza = Console.ReadLine().Split(' ');
            autobuskeStanice.Dodaj(int.Parse(veza[0]), int.Parse(veza[1]));
        }

        Console.WriteLine(autobuskeStanice.Rastojanje(pocetnaStanica, krajnjaStanica));
    }
}