#include <iostream>
#include <vector>
#include <queue>
#include <unordered_map>

using namespace std;

void dodajSusede(int cvor, std::vector<std::vector<int>>& susedi, std::unordered_map<int, int>& udaljenost, std::queue<int>& red) {
    for (int sused : susedi[cvor]) {
        if (udaljenost.find(sused) == udaljenost.end()) {
            udaljenost[sused] = udaljenost[cvor] + 1;
            red.push(sused);
        }
    }
}

int najmanjiBrojPresedanja(int N, int M, int S, int T, std::vector<int>& U, std::vector<int>& V) {
    std::vector<std::vector<int>> susedi(N + 1);
    for (int i = 0; i < M; ++i) {
        susedi[U[i]].push_back(V[i]);
        susedi[V[i]].push_back(U[i]);
    }

    std::unordered_map<int, int> udaljenost;
    std::queue<int> red;
    red.push(S);
    udaljenost[S] = 0;

    while (!red.empty()) {
        int cvor = red.front();
        red.pop();

        if (cvor == T) {
            return udaljenost[cvor];
        }

        dodajSusede(cvor, susedi, udaljenost, red);
    }

    return -1; // Putanja nije pronaÄ‘ena
}

bool provera_vec_postoji(std::vector<int> &U2, std::vector<int> &V2, int broj1, int broj2){
    for(int i = 0; i<U2.size(); i++){
        if ((U2[i] == broj1) && (V2[i]== broj2)) return true;
        if ((V2[i] == broj1) && (U2[i]== broj2)) return true;
    }
    return false;
}

void popuni_nove_nizove(std::vector<int> &U2, std::vector<int> &V2, int x1, int y1, int x2, int y2) {
    bool postoji;
    if (x1==x2) {
        postoji = provera_vec_postoji(U2,V2,y1,y2);
        if (!postoji) {
            U2.push_back(y1);
            V2.push_back(y2);
        }
    } else if (x1 == y2) {
        postoji = provera_vec_postoji(U2,V2,y1,x2);
        if (!postoji) {
            U2.push_back(y1);
            V2.push_back(x2);
        }
    } else if (y1 == y2) {
        postoji = provera_vec_postoji(U2,V2,x1,x2);
        if (!postoji) {
            U2.push_back(x1);
            V2.push_back(x2);
        }
    } else if (y1 == x2) {
        postoji = provera_vec_postoji(U2,V2,x1,y2);
        if (!postoji) {
            U2.push_back(x1);
            V2.push_back(y2);
        }
    }
}

int main()
{
   int N, M, S, T;
    // Unos prva 4 broja sa standardnog ulaza
    std::cout << "Unesite 4 broja (N M S T): ";
    std::cin >> N >> M >> S >> T;
    
    std::vector<int> U, V; // Nizovi U i V za smestanje parova brojeva
    std::vector<int> U2, V2;

    // Unos parova brojeva M puta
    for (int i = 0; i < M; ++i) {
        int prvi_broj, drugi_broj;
        std::cout << "Unesite par brojeva " << i+1 << " (prvi drugi): ";
        std::cin >> prvi_broj >> drugi_broj;

        U.push_back(prvi_broj); // Dodavanje prvog broja para u niz U
        V.push_back(drugi_broj); // Dodavanje drugog broja para u niz V
    }
    
    // Pravimo drugu mapu stanica
    
    for(int i=0; i<M-1; i++) {
        for(int j=i+1; j<M; j++) {
            popuni_nove_nizove(U2, V2, U[i], V[i], U[j], V[j]);
        }
    }
    
    int najkraciPut = najmanjiBrojPresedanja(N, M, S, T, U2, V2);
    
    std::cout << najkraciPut << std::endl;
    
    return 0;
}