using System.Collections.Generic;

public class Program
{
    public static void Main()
    {
        int N, M, S, T;

        Console.WriteLine("Unesite 4 broja (N M S T): ");
        string[] input = Console.ReadLine().Split(' ');
        N = int.Parse(input[0]);
        M = int.Parse(input[1]);
        S = int.Parse(input[2]);
        T = int.Parse(input[3]);

        List<int> U = new List<int>();
        List<int> V = new List<int>();
        List<int> U2 = new List<int>();
        List<int> V2 = new List<int>();

        for (int i = 0; i < M; ++i)
        {
            int prvi_broj, drugi_broj;
            Console.WriteLine("Unesite par brojeva " + (i + 1) + " (prvi drugi): ");
            input = Console.ReadLine().Split(' ');
            prvi_broj = int.Parse(input[0]);
            drugi_broj = int.Parse(input[1]);
            U.Add(prvi_broj);
            V.Add(drugi_broj);
 popuni_nove_nizove(U2, V2, prvi_broj, drugi_broj, U, V);
        }

        for (int i = 0; i < M - 1; i++)
        {
            for (int j = i + 1; j < M; j++)
            {
                popuni_nove_nizove(U2, V2, U[i], V[i], U[j], V[j]);
            }
        }
        int najkraciPut = najmanjiBrojPresedanja(N, M, S, T, U2, V2);
        Console.WriteLine(najkraciPut);
    }

    public static void popuni_nove_nizove(List<int> U2, List<int> V2, int x1, int y1, int x2, int y2)
    {
        bool postoji;
        if (x1 == x2)
        {
            postoji = provera_vec_postoji(U2, V2, y1, y2);
            if (!postoji)
            {
                U2.Add(y1);
                V2.Add(y2);
            }
        }
        else if (x1 == y2)
        {
            postoji = provera_vec_postoji(U2, V2, y1, x2);
            if (!postoji)
            {
                U2.Add(y1);
                V2.Add(x2);
            }
        }
        else if (y1 == y2)
        {
            postoji = provera_vec_postoji(U2, V2, x1, x2);
            if (!postoji)
            {
                U2.Add(x1);
                V2.Add(x2);
            }
        }
        else if (y1 == x2)
        {
            postoji = provera_vec_postoji(U2, V2, x1, y2);
            if (!postoji)
            {
                U2.Add(x1);
                V2.Add(y2);
            }
        }
    }

    public static bool provera_vec_postoji(List<int> U2, List<int> V2, int broj1, int broj2)
    {
        for (int i = 0; i < U2.Count; i++)
        {
            if ((U2[i] == broj1) && (V2[i] == broj2)) return true;
            if ((V2[i] == broj1) && (U2[i] == broj2)) return true;
        }
        return false;
    }

    public static int najmanjiBrojPresedanja(int N, int M, int S, int T, List<int> U, List<int> V)
    {
        List<List<int>> susedi = new List<List<int>>();
        for (int i = 0; i <= N; ++i)
        {
            susedi.Add(new List<int>());
        }
        for (int i = 0; i < M; ++i)
        {
            susedi[U[i]].Add(V[i]);
            susedi[V[i]].Add(U[i]);
        }
        Dictionary<int, int> udaljenost = new Dictionary<int, int>();
        Queue<int> red = new Queue<int>();
        red.Enqueue(S);
        udaljenost[S] = 0;
        while (red.Count > 0)
        {
            int cvor = red.Dequeue();
            if (cvor == T)
            {
                return udaljenost[cvor];
            }
            dodajSusede(cvor, susedi, udaljenost, red);
        }
        return -1;
    }

    public static void dodajSusede(int cvor, List<List<int>> susedi, Dictionary<int, int> udaljenost, Queue<int> red)
    {
        foreach (int sused in susedi[cvor])
        {
            if (!udaljenost.ContainsKey(sused))
            {
                udaljenost[sused] = udaljenost[cvor] + 1;
                red.Enqueue(sused);
            }
        }
    }
}