using System;
using System.Collections.Generic;

class Program
{
    static void Main()
    {
        string[] input = Console.ReadLine().Split();
        int N = int.Parse(input[0]);
        int M = int.Parse(input[1]);
        int S = int.Parse(input[2]);
        int T = int.Parse(input[3]);

        Dictionary<int, List<int>> g = new Dictionary<int, List<int>>();

        for (int i = 0; i < M; i++)
        {
            input = Console.ReadLine().Split();
            int U = int.Parse(input[0]);
            int V = int.Parse(input[1]);

            if (!g.ContainsKey(U))
                g[U] = new List<int>();

            if (!g.ContainsKey(V))
                g[V] = new List<int>();

            g[U].Add(V);
            g[V].Add(U);
        }

        int res = MinTran(N, g, S, T);
        Console.WriteLine(res/2);
    }

    static int MinTran(int N, Dictionary<int, List<int>> g, int start, int end)
    {
        Queue<int> q = new Queue<int>();
        HashSet<int> vis = new HashSet<int>();

        q.Enqueue(start);
        vis.Add(start);

        int t = 0;

        while (q.Count > 0)
        {
            int siz = q.Count;

            for (int i = 0; i < siz; i++)
            {
                int cur = q.Dequeue();

                if (cur == end)
                    return t;

                foreach (int n in g[cur])
                {
                    if (!vis.Contains(n))
                    {
                        q.Enqueue(n);
                        vis.Add(n);
                    }
                }
            }

            t++;
        }

        return -1;
    }
}