#include <bits/stdc++.h>

using namespace std;

const int MAXN = 200005;
vector<int> g[MAXN];
bool visited[MAXN];
int dist[MAXN];

int bfs(int S, int T) {
	queue<int> q;
	q.push(S);
	dist[S] = 0;
	while (!q.empty()) {
		int u = q.front();
		q.pop();
		if (visited[u]) continue;
		visited[u] = true;
		if (u == T) return dist[u];
		for (auto x: g[u]) {
			if (!visited[x] && dist[u] + 1 < dist[x]) {
				dist[x] = dist[u] + 1;
				q.push(x);
			}
		}
	}
	return 0;
}

int main() {
	ios_base::sync_with_stdio(false);
	cin.tie(0); cout.tie(0);

	int n;
	cin >> n;
	int m;
	cin >> m;
	int S, T;
	cin >> S >> T;

	for (int i = 0; i < m; ++i)
	{
		int a, b;
		cin >> a >> b;
		g[a].push_back(b);
		g[b].push_back(a);
	}

	for (int i = 0; i <= n; i++) {
		dist[i] = INT_MAX;
	}

	int dist = bfs(S, T);
	cout << dist / 2 << endl;


	return 0;
}