#include <bits/stdc++.h>

using namespace std;

const int MAXN = 200005;
vector<int> g[MAXN];
bool visited[MAXN];

int bfs(int S, int T) {
	queue<pair<int, int>> q;
	q.push({S, 0});
	while (!q.empty()) {
		auto uv = q.front();
		q.pop();
		int u = uv.first;
		int v = uv.second;
		if (u == T && v % 2 == 0) return v;
		if (visited[u]) continue;
		visited[u] = true;
		for (auto x: g[u]) {
			if (!visited[x] || x == T) {
				q.push({x, v + 1});
			}
		}
	}
	return 0;
}

int main() {
	ios_base::sync_with_stdio(false);
	cin.tie(0); cout.tie(0);

	int n;
	cin >> n;
	int m;
	cin >> m;
	int S, T;
	cin >> S >> T;

	for (int i = 0; i < m; ++i)
	{
		int a, b;
		cin >> a >> b;
		g[a].push_back(b);
		g[b].push_back(a);
	}

	int dist = bfs(S, T);
	cout << dist / 2 << endl;


	return 0;
}