import java.util.Scanner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class C {
	public static int nodesNumber,startNodeID,endNodeID;
	public static Map<Integer, List<Integer>> edges;
	
	public static void main(String[] args) { 
		System.out.println(input());
	}
	
	public static int input() {
		Scanner scanner = new Scanner(System.in);
		
		String[] input1 = scanner.nextLine().split(" ");
		nodesNumber = Integer.parseInt(input1[0]);
		int edgesNumber = Integer.parseInt(input1[1]);
		startNodeID = Integer.parseInt(input1[2]);
		endNodeID = Integer.parseInt(input1[3]);
		
		if (startNodeID == endNodeID) return 0;
		
		edges = new HashMap<>();
		String[] tempInput;
		int tempInt1, tempInt2;
		List<Integer> tempList;
		for(int i = 0 ; i < edgesNumber ; i++) {
			tempInput = scanner.nextLine().split(" ");
			tempInt1 = Integer.parseInt(tempInput[0]);
			tempInt2 = Integer.parseInt(tempInput[1]);
			if (!edges.containsKey(tempInt1)) {
				tempList = new ArrayList<>();
				tempList.add(tempInt2);
				edges.put(tempInt1, tempList);
			} else {
				tempList = edges.get(tempInt1);
				tempList.add(tempInt2);
				edges.put(tempInt1,tempList);
			}
			if (!edges.containsKey(tempInt2)) {
				tempList = new ArrayList<>();
				tempList.add(tempInt1);
				edges.put(tempInt2, tempList);
			} else {
				tempList = edges.get(tempInt2);
				tempList.add(tempInt1);
				edges.put(tempInt2,tempList);
			}
		}
		scanner.close();
		
		return bfs();
	}
	
	 public static int bfs() {
		Map<Integer, Integer> parent = new HashMap<>();
		ArrayList<Integer> queue = new ArrayList<>();
		boolean[] visited = new boolean[nodesNumber];

		queue.add(startNodeID);
		Arrays.fill(visited, false);
		visited[startNodeID-1] = true;
		
		int processingNode;
		while(!queue.isEmpty()) {
			processingNode = queue.get(0);
			queue.remove(Integer.valueOf(processingNode));
			for (int neighbor : edges.get(processingNode)) {
				if (!visited[neighbor-1]) {
					visited[neighbor-1] = true;
					queue.add(neighbor);
					parent.put(neighbor, processingNode);
				}
			}
		}
		
		int output = 0;
        processingNode = endNodeID;
        while (processingNode != -1) {
            output++;
            processingNode = parent.containsKey(processingNode) ? parent.get(processingNode) : -1;
        }
        return (int) Math.ceil((output-1)/2);
    }
}