using System;
using System.Collections.Generic;

class Program
{
    static int NajmanjiBrojPresedanja(int N, int M, int S, int T, List<Tuple<int, int>> parovi)
    {
        Dictionary<int, HashSet<int>> graf = new Dictionary<int, HashSet<int>>();
        for (int i = 1; i <= N; i++)
        {
            graf[i] = new HashSet<int>();
        }

        foreach (var par in parovi)
        {
            graf[par.Item1].Add(par.Item2);
            graf[par.Item2].Add(par.Item1);
        }

        HashSet<int> posete = new HashSet<int>();
        Queue<Tuple<int, int>> red = new Queue<Tuple<int, int>>();
        red.Enqueue(new Tuple<int, int>(S, 0));

        while (red.Count > 0)
        {
            var trenutnaStanica = red.Dequeue();
            int trenutna_stanica = trenutnaStanica.Item1;
            int broj_presedanja = trenutnaStanica.Item2;
            posete.Add(trenutna_stanica);

            if (trenutna_stanica == T)
            {
                return broj_presedanja;
            }

            foreach (var sused in graf[trenutna_stanica])
            {
                if (!posete.Contains(sused))
                {
                    red.Enqueue(new Tuple<int, int>(sused, broj_presedanja + 1));
                }
            }
        }

        return -1;
    }

    static void Main()
    {
        int N, M, S, T;
        List<Tuple<int, int>> parovi = new List<Tuple<int, int>>();

        string[] input = Console.ReadLine().Split();
        N = int.Parse(input[0]);
        M = int.Parse(input[1]);
        S = int.Parse(input[2]);
        T = int.Parse(input[3]);

        for (int i = 0; i < M; i++)
        {
            input = Console.ReadLine().Split();
            int U = int.Parse(input[0]);
            int V = int.Parse(input[1]);
            parovi.Add(new Tuple<int, int>(U, V));
        }
        int rezultat = NajmanjiBrojPresedanja(N, M, S, T, parovi);
        Console.WriteLine(rezultat);
    }
}