#include <iostream>
#include <vector>
#include <queue>
#include <limits>
#include <algorithm>
#include <cmath>

using namespace std;

typedef pair<int, int> pii;

const int INF = numeric_limits<int>::max();

void bfs(const vector<vector<int>>& graf, int pocetak, vector<int>& udaljenosti) {
    queue<int> red;
    red.push(pocetak);
    udaljenosti[pocetak] = 0;

    while (!red.empty()) {
        int current_vertex = red.front();
        red.pop();

        for (int komsija : graf[current_vertex]) {
            if (udaljenosti[komsija] == INF) {
                udaljenosti[komsija] = udaljenosti[current_vertex] + 1;
                red.push(komsija);
            }
        }
    }
}

int najkraci_put(int N, int M, int S, int T, const vector<vector<int>>& ivice) {
    vector<vector<int>> graf(N + 1);
    for (const auto& ivica : ivice) {
        int u = ivica[0];
        int v = ivica[1];
        graf[u].push_back(v);
        graf[v].push_back(u);  
    }

    vector<int> razdaljine(N + 1, INF);
    bfs(graf, S, razdaljine);

    return razdaljine[T];
}

int main() {
    int N, M, S, T;
    cin >> N >> M >> S >> T;

    vector<vector<int>> linije;
    for (int i = 0; i < M; ++i) {
        vector<int> ivica(2);
        cin >> ivica[0] >> ivica[1];
        linije.push_back(ivica);
    }

    int rezultat = najkraci_put(N, M, S, T, linije);
    cout << (rezultat+1)/2 << endl;

    return 0;
}