#include <bits/stdc++.h>

using namespace std;

int calc(vector<int> adj[], int n, int s, int t){
	bool vis[n] = {false};
	int dist[n];
	
	if(s == t) return 0;
	
	deque<int> q;
	q.push_back(s);
	vis[s] = true;
	dist[s] = 0;
	
	while(!q.empty()){
		int current = q.front();
		q.pop_front();
		
		for(int i : adj[current]){
			if(vis[i]) continue;
			vis[i] = true;
			q.push_back(i);
			dist[i] = dist[current] + 1;
			
			if(i == t){
				return dist[i];
			}
		}
	}
	
	return -1;
}

int main() {
	ios::sync_with_stdio(false); cin.tie(0);
	
	int n, m, s, t;
	cin>>n>>m>>s>>t;
	s--; t--;
	
	vector<int> adj[n];
	
	int a, b;
	for(int i = 0; i < m; i++){
		cin>>a>>b;
		adj[--a].push_back(--b);
		adj[b].push_back(a);
	}
	
	int dist = calc(adj, n, s, t);
	
	cout<<ceil(dist / 2.0);
	return 0;
}