using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO;
using System.Numerics;

namespace PrviKrug2023
{
    class Program
    {
        private static void dodajGranu(List<List<int>> graf, int i, int j)
        {
            graf[i].Add(j);
            graf[j].Add(i);
        }
        private static bool BFS(List<List<int>> graf, int s, int t, int n, int[] pret, int[] duzina)
        {
            List<int> red = new List<int>();
            bool[] pregledani = new bool[n];
            for (int i = 0; i < n; i++)
            {
                pregledani[i] = false;
                duzina[i] = int.MaxValue;
                pret[i] = -1;
            }
            pregledani[s] = true;
            duzina[s] = 0;
            red.Add(s);
            while (red.Count != 0)
            {
                int u = red[0];
                red.RemoveAt(0);
                for (int i = 0; i < graf[u].Count; i++)
                {
                    if (pregledani[graf[u][i]] == false)
                    {
                        pregledani[graf[u][i]] = true;
                        duzina[graf[u][i]] = duzina[u] + 1;
                        pret[graf[u][i]] = u;
                        red.Add(graf[u][i]);
                        if (graf[u][i] == t)
                            return true;
                    }
                }
            }
            return false;
        }
        private static void najkraciPut(List<List<int>> graf, int s, int t, int n)
        {
            int[] pret = new int[n];
            int[] duzina = new int[n];
            BFS(graf, s, t, n, pret, duzina);
            if (duzina[t] % 2 == 0)
            {
                Console.WriteLine(duzina[t] / 2);
            }
            else
            {
                Console.WriteLine(duzina[t] / 2 + 1);
            }
        }
        static void Main(string[] args)
        {
            string[] str = Console.ReadLine().Split();
            int n = int.Parse(str[0]);
            int m = int.Parse(str[1]);
            int s = int.Parse(str[2]) - 1;
            int t = int.Parse(str[3]) - 1;
            List<List<int>> graf = new List<List<int>>(n);
            for (int i = 0; i < n; i++)
            {
                graf.Add(new List<int>());
            }
            for (int i = 0; i < m; i++)
            {
                str = Console.ReadLine().Split();
                dodajGranu(graf, int.Parse(str[0]) - 1, int.Parse(str[1]) - 1);
            }
            najkraciPut(graf, s, t, n);
        }
    }
}