using System;
using System.Collections.Generic;

class Program
{
    static void Main()
    {
        string[] input = Console.ReadLine().Split();
        int n = int.Parse(input[0]); // broj autobuskih stanica
        int m = int.Parse(input[1]); // povezane stanice
        int s = int.Parse(input[2]); // stanica na kojoj se nalazimo
        int t = int.Parse(input[3]); // stanica do koje treba da dodjemo

        Dictionary<int, List<int>> putevi = new Dictionary<int, List<int>>();

        for (int i = 0; i < m; i++)
        {
            string[] A = Console.ReadLine().Split();
            int u = int.Parse(A[0]);
            int v = int.Parse(A[1]);

            if (!putevi.ContainsKey(u))                    //U i V
                putevi[u] = new List<int>();

            if (!putevi.ContainsKey(v))
                putevi[v] = new List<int>();

            putevi[u].Add(v);
            putevi[v].Add(u);
        }

        Putevi(putevi, s, t);
    }

    static void Putevi(Dictionary<int, List<int>> putevi, int sad, int t)
    {
        HashSet<int> v = new HashSet<int>();
        List<int> put = new List<int>();
        List<int> minP = new List<int>();
        int mPr = int.MaxValue;

        v.Add(sad);
        put.Add(sad);

        DFS(putevi, sad, t, v, put, minP, ref mPr);

        Console.WriteLine(mPr);
    }

    static void DFS(Dictionary<int, List<int>> putevi, int sad, int t, HashSet<int> v, List<int> put, List<int> minP, ref int mPr)
    {
        if (sad == t)
        {
            int promena = Brput(put);

            if (promena < mPr)
            {
                mPr = promena;
                minP.Clear();
                minP.AddRange(put);
            }

            return;
        }

        foreach (int pomoc in putevi[sad])
        {
            if (!v.Contains(pomoc))
            {
                v.Add(pomoc);
                put.Add(pomoc);
                DFS(putevi, pomoc, t, v, put, minP, ref mPr);
                v.Remove(pomoc);
                put.RemoveAt(put.Count - 1);
            }
        }
    }

    static int Brput(List<int> put)
    {
        int promena = 1;
        int poma = 0;                                      //koriscenje pomocnih poma i pomb 

        for (int i = 1; i < put.Count; i++)
        {
            int pomb = Math.Sign(put[i] - put[i - 1]);

            if (poma != 0 && poma != pomb)
            {
                promena++;
            }

            poma = pomb;
        }

        return promena;
    }
}