#include <iostream>
#include <vector>
#include <queue>

using namespace std;

struct Cvor {
    int u, v;
};

bool bfs(int n, int s, int t, vector<vector<int>>& adj) {
    vector<int> vec(n, -1);
    queue<int> q;
    vec[s] = 0;
    q.push(s);

    while (!q.empty()) {
        int u = q.front();
        q.pop();
        if (u == t) {
            return true;
        }
        for (int v : adj[u]) {
            if (vec[v] == -1) {
                vec[v] = vec[u] + 1;
                q.push(v);
            }
        }
    }

    return false;
}

int main() {
	int n, m, s, t;
	vector<Cvor> cvorovi;
	vector<vector<int>> adj;
    cin >> n >> m >> s >> t;
    adj.resize(n);

    for (int i = 0; i < m; i++) {
        int u, v;
        cin >> u >> v;
        u--; 
		v--;
        cvorovi.push_back({u, v});
        adj[u].push_back(v);
        adj[v].push_back(u);
    }

    if (bfs(n, s, t, adj)) {
        cout << "1" << endl;
    } else {
        cout << "2" << endl;
    }

    return 0;
}