#include <iostream>
#include <vector>
#include <queue>

using namespace std;

#define MAX_NODES 200001

struct Put {
    int pocetna;
    int destinacija;
};

struct Graf {
    vector<int> lista[MAX_NODES];
};

int najkraci(Graf& graf, int s, int t) {
    
    return pronalazac(graf, s, t);
}

int pronalazac(Graf& graf, int pocetak, int kraj) {
    int trenutna, putanja;
    
    queue<pair<int, int>> queue;
    queue.push({pocetak, 0});
    vector<bool> posecene(MAX_NODES, false);
    posecene[pocetak] = true;

    while (!queue.empty()) {
        
        trenutna = queue.front().first;
        putanja = queue.front().second;
        queue.pop();
        
        if (trenutna == kraj) {
            
            return putanja;
        }
        
        for (int povezane : graf.lista[trenutna]) {
            
            if (!posecene[povezane]) {
                queue.push({povezane, putanja + 1});
                posecene[povezane] = true;
            }
        }
    }

    return -1;
}

int main() {
    int brojStanica, brojPovezanih, pocetnaStanica, poslednjaStanica, i, Ui, Vi, najkraciPut;
    
    cin >> brojStanica;
    cin >> brojPovezanih;
    cin >> pocetnaStanica;
    cin >> poslednjaStanica;

    Graf noviPlan;

    for (i = 0 ; i < brojPovezanih ; i++) {
        cin >> Ui;
        cin >> Vi;
        
        noviPlan.lista[Ui].push_back(Vi);
        noviPlan.lista[Vi].push_back(Ui);
    }

    najkraciPut = najkraci(noviPlan, pocetnaStanica, poslednjaStanica);

    cout << najkraciPut / 2 << endl;

    return 0;
}