using System;
using System.Collections.Generic;
using System.Linq;

namespace presedanja
{
    internal class Program
    {
        static int brojBusevaPoStaromPlanu(int[][] autobuskelinije, int pocetak, int cilj)
        {
            if (pocetak == cilj)
            {
                return 0;
            }

            Dictionary<int, List<int>> stajalista = new Dictionary<int, List<int>>();

            for (int i = 0; i < autobuskelinije.Length; i++)
            {
                foreach (var stanica in autobuskelinije[i])
                {
                    if (!stajalista.ContainsKey(stanica))
                    {
                        stajalista[stanica] = new List<int>();
                    }
                    stajalista[stanica].Add(i);
                }
            }

            HashSet<int> poseteAutobusa = new HashSet<int>();
            HashSet<int> poseteStajalista = new HashSet<int>();
            Queue<int> redStajalista = new Queue<int>();

            foreach (var autobus in stajalista[pocetak])
            {
                poseteAutobusa.Add(autobus);
                redStajalista.Enqueue(autobus);
            }

            int presedanja = 1;

            while (redStajalista.Count > 0)
            {
                int brojStajalista = redStajalista.Count;

                for (int i = 0; i < brojStajalista; i++)
                {
                    int trenutniAutobus = redStajalista.Dequeue();

                    foreach (var stanica in autobuskelinije[trenutniAutobus])
                    {
                        if (stanica == cilj)
                        {
                            return presedanja;
                        }

                        if (!poseteStajalista.Contains(stanica))
                        {
                            poseteStajalista.Add(stanica);

                            foreach (var susedniAutobus in stajalista[stanica])
                            {
                                if (!poseteAutobusa.Contains(susedniAutobus))
                                {
                                    poseteAutobusa.Add(susedniAutobus);
                                    redStajalista.Enqueue(susedniAutobus);
                                }
                            }
                        }
                    }
                }

                presedanja++;
            }

            return -1;
        }

        static void Main(string[] args)
        {
            int N, M, S,T;
            string[] u = Console.ReadLine().Split(' ');
            N = int.Parse(u[0]); M= int.Parse(u[1]);
            S= int.Parse(u[2]);T= int.Parse(u[3]);
            int[][] autobuskelinije = new int[M][];
            for (int i = 0; i < M; i++)
            {
                u = Console.ReadLine().Split(' ');
                int[] a = new int[2];
                for (int j = 0; j < 2; j++)
                {
                    a[j] = int.Parse(u[j]);
                }
                autobuskelinije[i] = a;
            }
            int D=brojBusevaPoStaromPlanu(autobuskelinije, S, T);
            if(D%2==0) Console.WriteLine(D/2);
            else Console.WriteLine(D/2+1);
        }


    }
}