using System;
using System.Collections.Generic;

class Program
{
    static void Main()
    {
        string[] unos = Console.ReadLine().Split();
        int N = int.Parse(unos[0]);
        int M = int.Parse(unos[1]);
        int S = int.Parse(unos[2]);
        int T = int.Parse(unos[3]);

        Dictionary<int, List<int>> graf = new Dictionary<int, List<int>>();

        for (int i = 0; i < M; i++)
        {
            unos = Console.ReadLine().Split();
            int U = int.Parse(unos[0]);
            int V = int.Parse(unos[1]);

            if (!graf.ContainsKey(U))
                graf[U] = new List<int>();

            if (!graf.ContainsKey(V))
                graf[V] = new List<int>();

            graf[U].Add(V);
            graf[V].Add(U);
        }

        int rezultat = MinTransferi(N, graf, S, T);
        Console.WriteLine(rezultat / 2);
    }

    static int MinTransferi(int N, Dictionary<int, List<int>> graf, int start, int end)
    {
        Queue<int> red = new Queue<int>();
        HashSet<int> poseceno = new HashSet<int>();

        red.Enqueue(start);
        poseceno.Add(start);

        int transferi = 0;

        while (red.Count > 0)
        {
            int velicina = red.Count;

            for (int i = 0; i < velicina; i++)
            {
                int trenutni = red.Dequeue();

                if (trenutni == end)
                    return transferi;

                foreach (int sused in graf[trenutni])
                {
                    if (!poseceno.Contains(sused))
                    {
                        red.Enqueue(sused);
                        poseceno.Add(sused);
                    }
                }
            }

            transferi++;
        }

        return -1;
    }
}